package com.bxm.localnews.merchant.param.goods;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author: zhoujincheng
 * @create: 2020-08-20 16:16
 */

@Data
@ApiModel(description = "创建商品入参")
public class GoodsCreateParam {


    @ApiModelProperty(value = "商品类型0单品1套餐", required = true)
    @NotNull(message = "商品类型不能为空")
    private Integer type;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String name;

    @ApiModelProperty(value = "原价", required = true)
    @NotNull(message = "商品原价不能为空")
    private BigDecimal originalPrice;

    @ApiModelProperty(value = "现价", required = true)
    @NotNull(message = "商品现价不能为空")
    private BigDecimal price;

    @ApiModelProperty(value = "库存", required = true)
    @NotNull(message = "商品库存不能为空")
    private Integer num;

    @ApiModelProperty(value = "0关闭vip折扣1开启vip折扣", required = true)
    @NotNull(message = "vip折扣类型不能为空")
    private Integer vipDiscount;

    @ApiModelProperty(value = "佣金比例", required = true)
    @NotNull(message = "佣金比例不能为空")
    private Integer commissionRate;

    @ApiModelProperty(value = "商品轮播图", required = true)
    @NotBlank(message = "商品轮播图不能为空")
    private String headPics;

    @ApiModelProperty("使用规则")
    private String rule;

    @ApiModelProperty("店铺详情")
    private String detail;

    @ApiModelProperty(value = "商家id", required = true)
    @NotNull(message = "商家id不能为空")
    private Long merchantId;

    @ApiModelProperty("套餐内容")
    private String setMeal;

}
