package com.bxm.localnews.merchant.param.order;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户业务订单参数")
@Data
public class UserOrderParam extends BasicParam {

    @ApiModelProperty(value = "下单用户ID", required = true)
    @NotNull(message = "下单用户不能为空")
    private Long userId;

    @ApiModelProperty(value = "支付方式,1:微信支付，2：支付宝支付，3：微信JS-API支付", allowableValues = "1,2,3", required = true)
    @NotNull(message = "请选择支付方式")
    private Byte payType;

    @ApiModelProperty(value = "订单类型，" +
            "welfareVip : 福利VIP卡（3.2.0新版本）," +
            "localVip ：VIP卡（历史版本）" +
            "redPacket : 口令红包" +
            "merchantVip : 商家购买VIP权益" +
            "userBuyGoods : 用户购买商品（可为商品，也可以是商品 + 权益的购买）", required = true)
    @NotBlank(message = "请选择订单类型")
    private String orderType;

    @ApiModelProperty("订单号 如果是用户购买商品 则传入商品订单号")
    private String orderSn;

    @ApiModelProperty("微信code，微信jsapi支付时需要提供")
    private String wechatCode;

    @ApiModelProperty("支付成功后的跳转地址")
    private String returnUrl;

    @ApiModelProperty("创建的支付订单相关联的业务ID，选填")
    private Long bizId;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "请求来源IP", hidden = true)
    private String requestIp;

    @ApiModelProperty("分享人的id")
    private String inviterId;

    @ApiModelProperty(value = "支付流水标题 如果是商品支付则传入商品标题", required = true)
    private String paymentTitle;

}

