package com.bxm.localnews.merchant.vo;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel(description = "商家认证信息")
public class MerchantAuthInfo {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("关联商家id")
    private Long merchantId;

    @ApiModelProperty("认证状态 0: 未提交、待认证 1: 已提待审核 2: 审核通过 3: 审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("营业执照图片地址")
    private String licensePic;

    @ApiModelProperty("法人身份证正面照片")
    private String legalPersonFacePic;

    @ApiModelProperty("法人身份证反面照片")
    private String legalPersonBackPic;

    @ApiModelProperty("备注信息")
    private String remark;

    @ApiModelProperty("创建时间，也就是商家申请入驻时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @ApiModelProperty("0有营业执照1无营业执照")
    private Integer type;

}
