package com.bxm.localnews.merchant.vo.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: zhoujincheng
 * @create: 2020-08-25 16:03
 */
@Data
public class GoodsListVo {
    @ApiModelProperty("商品id")
    private Long id;

    @ApiModelProperty("0:待审核 1: 资质审核通过 2: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("店铺公司名称")
    private String merchantName;

    @ApiModelProperty("行业名称")
    private String catName;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("库存")
    private Integer num;

    @ApiModelProperty("总量")
    private Integer totalNum;

    private Integer commissionRate;

    @ApiModelProperty("上下架状态 0：下架 1：上架")
    private Integer shelfType;

    @ApiModelProperty("商品id")
    private Long goodsId;


   /*
   *
   * 新增
   * */

    @ApiModelProperty("单笔分销金额")
    private BigDecimal distributionAmount;

    @ApiModelProperty("已售")
    private Integer saleNum;

}
