package com.bxm.localnews.merchant.vo.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: zhoujincheng
 * @create: 2020-08-28 10:10
 */
@Data
public class MerchantGoodsListVo {

    @ApiModelProperty("商品id")
    private Long id;

    @ApiModelProperty("商品轮播图")
    private String headPics;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("库存")
    private Integer num;

    @ApiModelProperty("0:待用户提交审核 1:审核中 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("总量")
    private Integer totalNum;

    private Integer sort;

    @ApiModelProperty("佣金比例")
    private Integer commissionRate;

    @ApiModelProperty("计算后的vip折扣价格")
    private BigDecimal vipPrice;

    @ApiModelProperty("立赚价格")
    private BigDecimal immediatelyPrice;

    @ApiModelProperty("商品展示图")
    private String img;

    @ApiModelProperty("已售")
    private Integer saleNum;

    @ApiModelProperty("商品id")
    private Long goodsId;

    @ApiModelProperty("计算后的折扣")
    private BigDecimal discount;
}
