package com.bxm.localnews.merchant.vo.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;


@Data
public class MerchantGoodsVo {

    @ApiModelProperty("商品id")
    private Long id;

    @ApiModelProperty("商品类型0单品1套餐")
    private Integer type;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("商品轮播图")
    private String headPics;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("库存")
    private Integer num;

    @ApiModelProperty("总量")
    private Integer totalNum;

    @ApiModelProperty("0关闭vip折扣1开启vip折扣")
    private Integer vipDiscount;

    @ApiModelProperty("佣金比例")
    private Integer commissionRate;

    @ApiModelProperty("使用规则")
    private String rule;

    @ApiModelProperty("店铺详情")
    private String detail;

    @ApiModelProperty("0:待审核 1: 资质审核通过 2: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("0下架1上架")
    private Integer shelfType;

    @ApiModelProperty("商品排序")
    private Integer sort;

    @ApiModelProperty("0删除1正常")
    private Integer state;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @ApiModelProperty("套餐内容")
    private String setMeal;

    @ApiModelProperty("版本号")
    private Integer version;


}