package com.bxm.localnews.merchant.security.service;

import com.bxm.localnews.merchant.common.constant.MerchantMemberEnum;
import com.bxm.localnews.merchant.domain.MerchantNotifactionMapper;
import com.bxm.localnews.merchant.integration.AbstractPushService;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.vo.MerchantNotifactionVo;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author liujia
 * @date 12/23/20 8:55 PM
 **/
@Component
public class MemberMessageService extends AbstractPushService {

    @Autowired
    private MerchantNotifactionMapper merchantNotifactionMapper;

    /**
     * 绑定相关通知
     */
    public void pushMerchantMemberMsg(MerchantMemberVo merchantMemberVo, MerchantInfo merchantInfo, MerchantMemberEnum merchantMemberEnum) {
        String title;
        String content;
        String url = "";
        PushMessage message = null;

        if (MerchantMemberEnum.PUSH_TOBOSS_SUCESSS.equals(merchantMemberEnum)) {
            //绑定成功  老板推送
            title = "绑定员工成功";
            content = "您已成功绑定" + merchantMemberVo.getNickName() + "为您员工,详情请在商家中心，全员营销中查看~";
            url = getBossAddress(merchantInfo);
            message = pushMerchantMember(merchantInfo.getUserId(), url, title, content);
            pushMerchantMember(merchantInfo.getUserId(), url, title, content);
        } else if (MerchantMemberEnum.PUSH_TOEMPLOYEE_SUCESSS.equals(merchantMemberEnum)) {
            //绑定成功  员工推送
            title = "成功加入团队";
            content = "恭喜你，成功加入" + merchantInfo.getShortName() + "团队,现在进入我的营销中一起赚钱吧~";
            url = getEmployeeAddressToCenter(merchantMemberVo.getMerchantId(), merchantInfo.getUserId());
            message = pushMerchantMember(merchantMemberVo.getUserId(), url, title, content);
        } else if (MerchantMemberEnum.PUSH_TOBOSS_FAIL.equals(merchantMemberEnum)) {
            //解除绑定  老板推送
            title = "员工解绑通知";
            content = merchantMemberVo.getNickName() + "和您解除了员工关系，详情请在商家中心，全员营销中查看";
            url = getBossAddress(merchantInfo);
            message = pushMerchantMember(merchantInfo.getUserId(), url, title, content);
        } else if (MerchantMemberEnum.PUSH_TOEMPLOYEE_FAIL.equals(merchantMemberEnum)) {
            //解除绑定  员工推送
            title = "员工解绑通知";
            content = merchantInfo.getShortName() + "已解除和您的成员关系";
            message = pushMerchantMember(merchantMemberVo.getUserId(), url, title, content);
            pushMerchantMember(merchantMemberVo.getUserId(), url, title, content);
        }
        if (message != null) {
            messageSender.sendPushMessage(message);
        }
    }

    public void addLog(Long merchantId, String message, String type) {
        MerchantNotifactionVo merchantNotifactionVo = new MerchantNotifactionVo();
        merchantNotifactionVo.setMerchant(merchantId);
        merchantNotifactionVo.setMessage(message);
        if (type == null) {
            merchantNotifactionVo.setType("邀请成功");
        }
        merchantNotifactionVo.setCreateTime(new Date());
        merchantNotifactionMapper.insertSelective(merchantNotifactionVo);
    }
}
