package com.bxm.localnews.merchant.security.service;

import com.bxm.localnews.merchant.security.dto.MerchantMemberRoleDTO;
import com.bxm.localnews.merchant.security.enums.MerchantRoleEnum;

/**
 * 商户权限管理服务接口
 *
 * @author liujia
 * @date 12/23/20 2:44 PM
 **/
public interface MerchantAuthService {

    /**
     * 获取商家成员在商家中的权限
     *
     * @param userId     商家成员用户ID
     * @param merchantId 商家ID
     * @return 商家成员在商家中设定的角色，如果为null则表示该成员在商户中无权限
     */
    MerchantMemberRoleDTO getMemberRole(Long userId, Long merchantId);

    /**
     * 初始化商家成员权限信息
     *
     * @param merchantId 商家ID
     * @param memberId   商家成员ID
     * @param role       成员角色
     */
    void initAuth(Long merchantId, Long memberId, MerchantRoleEnum role);
}
