package com.bxm.localnews.merchant.security.service;

import com.bxm.localnews.merchant.param.EmployeeRemoveParam;
import com.bxm.localnews.merchant.param.RemoveRecordParam;
import com.bxm.localnews.merchant.security.facade.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.security.facade.param.MemberTeamParam;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.security.param.MerchantMemberPageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 商家成员管理相关接口
 *
 * @author zhoujincheng
 * @date 2020-07-30 17:14
 */
public interface MerchantMemberService {

    /**
     * 解除绑定关系
     */
    Message remove(EmployeeRemoveParam employeeRemoveParam);

    /**
     * 删除绑定记录
     */
    Message removeRecord(RemoveRecordParam removeRecordParam);

    /**
     * 员工列表
     */
    PageWarper<MerchantMemberVo> getEmployeeList(MerchantMemberPageParam merchantMemberPageParam);

    /**
     * 获取商户和用户综合信息
     */
    Message getMerchantUserInfo(Long userId);

    /**
     * 商家团队成员信息
     *
     * @param param 查询上行参数
     * @return 商家团队成员信息分页列表数据
     */
    PageWarper<MechantTeamInfosDTO> getMemberList(MemberTeamParam param);

    /**
     * 获取成员身份信息
     *
     * @param userId 用户ID
     * @return 成员信息
     */
    MerchantMemberVo getMemberInfo(Long userId);
}
