package com.bxm.localnews.merchant.security.service.impl;

import com.bxm.localnews.merchant.domain.security.MerchantSecurityAuthMapper;
import com.bxm.localnews.merchant.security.dto.MerchantMemberRoleDTO;
import com.bxm.localnews.merchant.security.entity.MerchantSecurityAuthBean;
import com.bxm.localnews.merchant.security.enums.MerchantAuthCodeEnum;
import com.bxm.localnews.merchant.security.enums.MerchantRoleEnum;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.security.service.MerchantAuthService;
import com.bxm.localnews.merchant.security.service.MerchantMemberService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author liujia
 * @date 12/23/20 2:55 PM
 **/
@Service
@Slf4j
public class MerchantAuthServiceImpl implements MerchantAuthService {


    private final MerchantSecurityAuthMapper merchantSecurityAuthMapper;

    private final MerchantMemberService merchantMemberService;

    private final SequenceCreater sequenceCreater;

    @Autowired
    public MerchantAuthServiceImpl(MerchantSecurityAuthMapper merchantSecurityAuthMapper,
                                   MerchantMemberService merchantMemberService,
                                   SequenceCreater sequenceCreater) {
        this.merchantSecurityAuthMapper = merchantSecurityAuthMapper;
        this.merchantMemberService = merchantMemberService;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public MerchantMemberRoleDTO getMemberRole(Long userId, Long merchantId) {
        MerchantMemberVo memberInfo = merchantMemberService.getMemberInfo(userId);

        if (null == memberInfo) {
            return null;
        }

        MerchantRoleEnum role = MerchantRoleEnum.getRole(memberInfo.getRole());
        if (role == null) {
            return null;
        }

        List<MerchantSecurityAuthBean> authList = merchantSecurityAuthMapper.selectMemberAuth(userId, merchantId);

        return MerchantMemberRoleDTO.builder()
                .roleCode(role.getRoleCode())
                .roleName(role.getRoleName())
                .authCodes(authList.stream().map(MerchantSecurityAuthBean::getAuthCode).collect(Collectors.toList()))
                .build();
    }

    @Override
    public void initAuth(Long merchantId, Long memberId, MerchantRoleEnum role) {
        for (MerchantAuthCodeEnum authCode : role.getAuthCodes()) {
            MerchantSecurityAuthBean authBean = new MerchantSecurityAuthBean();
            authBean.setId(sequenceCreater.nextLongId());
            authBean.setAuthCode(authCode.name());
            authBean.setMerchantId(merchantId);
            authBean.setMemberUserId(memberId);
            authBean.setCreateTime(new Date());

            merchantSecurityAuthMapper.insert(authBean);
        }
    }
}
