/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.security.service.impl;

import com.bxm.localnews.merchant.domain.security.MerchantSecurityAuthMapper;
import com.bxm.localnews.merchant.security.dto.MerchantMemberRoleDTO;
import com.bxm.localnews.merchant.security.entity.MerchantSecurityAuthBean;
import com.bxm.localnews.merchant.security.enums.MerchantAuthCodeEnum;
import com.bxm.localnews.merchant.security.enums.MerchantRoleEnum;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.security.service.MerchantAuthService;
import com.bxm.localnews.merchant.security.service.MerchantMemberService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantAuthServiceImpl
implements MerchantAuthService {
    private static final Logger log = LoggerFactory.getLogger(MerchantAuthServiceImpl.class);
    private final MerchantSecurityAuthMapper merchantSecurityAuthMapper;
    private final MerchantMemberService merchantMemberService;
    private final SequenceCreater sequenceCreater;

    @Autowired
    public MerchantAuthServiceImpl(MerchantSecurityAuthMapper merchantSecurityAuthMapper, MerchantMemberService merchantMemberService, SequenceCreater sequenceCreater) {
        this.merchantSecurityAuthMapper = merchantSecurityAuthMapper;
        this.merchantMemberService = merchantMemberService;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public MerchantMemberRoleDTO getMemberRole(Long userId, Long merchantId) {
        MerchantMemberVo memberInfo = this.merchantMemberService.getMemberInfo(userId);
        if (null == memberInfo) {
            return null;
        }
        MerchantRoleEnum role = MerchantRoleEnum.getRole((Integer)memberInfo.getRole());
        if (role == null) {
            return null;
        }
        List authList = this.merchantSecurityAuthMapper.selectMemberAuth(userId, merchantId);
        return MerchantMemberRoleDTO.builder().roleCode(role.getRoleCode()).roleName(role.getRoleName()).authCodes(authList.stream().map(MerchantSecurityAuthBean::getAuthCode).collect(Collectors.toList())).build();
    }

    @Override
    public void initAuth(Long merchantId, Long memberId, MerchantRoleEnum role) {
        for (MerchantAuthCodeEnum authCode : role.getAuthCodes()) {
            MerchantSecurityAuthBean authBean = new MerchantSecurityAuthBean();
            authBean.setId(this.sequenceCreater.nextLongId());
            authBean.setAuthCode(authCode.name());
            authBean.setMerchantId(merchantId);
            authBean.setMemberUserId(memberId);
            authBean.setCreateTime(new Date());
            this.merchantSecurityAuthMapper.insert(authBean);
        }
    }
}

