/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.security.service.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantMemberEnum;
import com.bxm.localnews.merchant.domain.security.MerchantMemberMapper;
import com.bxm.localnews.merchant.dto.CreateStatusDto;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.UserInviteHistoryBean;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.integration.UserInviteIntegrationService;
import com.bxm.localnews.merchant.security.enums.MerchantRoleEnum;
import com.bxm.localnews.merchant.security.facade.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.security.facade.dto.RelationshipDto;
import com.bxm.localnews.merchant.security.facade.param.CreateParam;
import com.bxm.localnews.merchant.security.facade.param.MemberTeamParam;
import com.bxm.localnews.merchant.security.facade.service.MerchantMemberFacadeService;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.security.service.MemberMessageService;
import com.bxm.localnews.merchant.security.service.MerchantAuthService;
import com.bxm.localnews.merchant.security.service.MerchantMemberService;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MerchantMemberFacadeServiceImpl
implements MerchantMemberFacadeService {
    private static final Logger log = LoggerFactory.getLogger(MerchantMemberFacadeServiceImpl.class);
    private RedisHashMapAdapter redisHashMapAdapter;
    private MerchantMemberMapper merchantMemberMapper;
    private UserInviteIntegrationService userInviteIntegrationService;
    private UserIntegrationService userIntegrationService;
    private MerchantInfoFacadeService merchantInfoFacadeService;
    private MemberMessageService memberMessageService;
    private RedisStringAdapter redisStringAdapter;
    private MerchantMemberService merchantMemberService;

    private MerchantAuthService getMerchantAuthService() {
        return (MerchantAuthService)SpringContextHolder.getBean(MerchantAuthService.class);
    }

    public PageWarper<MechantTeamInfosDTO> getMemberInfo(MemberTeamParam param) {
        return this.merchantMemberService.getMemberList(param);
    }

    public List<MerchantMemberVo> getAllEffectiveMember() {
        return this.merchantMemberMapper.getMerchantMemberList();
    }

    public MerchantMemberVo getBoosByMerchantId(Long merchantId) {
        MerchantMemberVo bossMember = this.merchantMemberMapper.getBossByMerchantId(merchantId);
        if (bossMember == null) {
            bossMember = new MerchantMemberVo();
            bossMember.setUserId(Long.valueOf(0L));
            log.error("\u5f02\u5e38\u6570\u636e\uff0c\u5546\u5bb6[{}]\u4e0d\u5b58\u5728\u8001\u677f", (Object)merchantId);
        }
        return bossMember;
    }

    public RelationshipDto getRelationship(Long userId) {
        UserInviteHistoryBean userInviteHistoryBean;
        MerchantMemberVo merchantMemberVo = this.getMemberInfo(userId);
        if (merchantMemberVo != null) {
            if (Objects.equals(merchantMemberVo.getRole(), MerchantRoleEnum.MEMBER_ROLE_BOSS.getRoleCode())) {
                return this.getRelationshipDto(0, merchantMemberVo.getMerchantId(), merchantMemberVo.getUserId(), null, null);
            }
            if (Objects.equals(merchantMemberVo.getRole(), MerchantRoleEnum.MEMBER_ROLE_EMPLOYEE.getRoleCode())) {
                return this.getRelationshipDto(1, merchantMemberVo.getMerchantId(), null, merchantMemberVo.getUserId(), null);
            }
        }
        if (Objects.nonNull(userInviteHistoryBean = this.userInviteIntegrationService.selectByUserId(userId))) {
            RelationshipDto relationshipDto;
            if (userInviteHistoryBean.getInviteUserId() != null && userInviteHistoryBean.getInviteUserId().intValue() > 0 && Objects.nonNull(relationshipDto = this.getBindInfo(userInviteHistoryBean.getInviteUserId()))) {
                return relationshipDto;
            }
            if (userInviteHistoryBean.getInviteSuperUserId() != null && userInviteHistoryBean.getInviteSuperUserId().intValue() > 0 && Objects.nonNull(relationshipDto = this.getBindInfo(userInviteHistoryBean.getInviteSuperUserId()))) {
                return relationshipDto;
            }
        }
        return null;
    }

    private RelationshipDto getBindInfo(Long userId) {
        MerchantMemberVo vo = this.getMemberInfo(userId);
        if (vo != null) {
            if (Objects.equals(vo.getRole(), MerchantRoleEnum.MEMBER_ROLE_BOSS.getRoleCode())) {
                return this.getRelationshipDto(2, vo.getMerchantId(), vo.getUserId(), null, vo.getUserId());
            }
            if (Objects.equals(vo.getRole(), MerchantRoleEnum.MEMBER_ROLE_EMPLOYEE.getRoleCode())) {
                return this.getRelationshipDto(3, vo.getMerchantId(), null, vo.getUserId(), vo.getUserId());
            }
        }
        return null;
    }

    private RelationshipDto getRelationshipDto(Integer type, Long merchantId, Long bossUserId, Long employeeUserId, Long inviteSuperUserId) {
        RelationshipDto relationshipDto = new RelationshipDto();
        relationshipDto.setType(type);
        relationshipDto.setMerchantId(merchantId);
        relationshipDto.setBossUserId(bossUserId);
        relationshipDto.setEmployeeUserId(employeeUserId);
        relationshipDto.setInviteSuperUserId(inviteSuperUserId);
        return relationshipDto;
    }

    public MerchantMemberVo getMemberInfo(Long userId) {
        return this.merchantMemberService.getMemberInfo(userId);
    }

    public int memberNum(Long merchantId) {
        return this.merchantMemberMapper.memberNum(merchantId);
    }

    @Async
    public void bossCreate(Long merchantId, Long userId) {
        try {
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
            merchantMemberVo.setMerchantId(merchantId);
            merchantMemberVo.setUserId(userId);
            if (userInfoDTO != null && userInfoDTO.getState() != null) {
                merchantMemberVo.setNickName(userInfoDTO.getNickname());
                merchantMemberVo.setHeadImg(userInfoDTO.getHeadImg());
            }
            merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_YES.getType());
            merchantMemberVo.setRole(MerchantRoleEnum.MEMBER_ROLE_BOSS.getRoleCode());
            merchantMemberVo.setCreateTime(new Date());
            merchantMemberVo.setBindTime(new Date());
            this.merchantMemberMapper.insertSelective(merchantMemberVo);
            this.getMerchantAuthService().initAuth(merchantId, userId, MerchantRoleEnum.MEMBER_ROLE_BOSS);
            this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, String.valueOf(merchantMemberVo.getUserId()), (Object)merchantMemberVo);
            this.memberMessageService.addLog(merchantId, "\u8001\u677f\u52a0\u5165\u56e2\u961f\u6210\u529f", null);
        }
        catch (Exception e) {
            log.error("\u8001\u677f" + userId + "\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
    }

    public Message create(CreateParam createParam) {
        int register;
        String headImg;
        String nickname;
        CreateStatusDto createStatusDto = new CreateStatusDto();
        MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
        BeanUtils.copyProperties((Object)createParam, (Object)merchantMemberVo);
        MerchantInfo merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(createParam.getMerchantId());
        if (merchantInfo == null) {
            log.debug("\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f" + createParam.getMerchantId());
            return Message.build((boolean)false, (String)"\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f");
        }
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(createParam.getUserId());
        if (userInfoDTO != null && userInfoDTO.getState() != null) {
            nickname = userInfoDTO.getNickname();
            headImg = userInfoDTO.getHeadImg();
            createStatusDto.setRegister(Integer.valueOf(0));
            register = 0;
        } else {
            nickname = createParam.getNickName();
            headImg = createParam.getHeadImg();
            createStatusDto.setRegister(Integer.valueOf(1));
            register = 1;
        }
        MerchantMemberVo memberInfo = this.getMemberInfo(createParam.getUserId());
        if (memberInfo != null) {
            MerchantInfo vo = this.merchantInfoFacadeService.getMerchantInfo(memberInfo.getMerchantId());
            if (vo != null) {
                createStatusDto.setContent("\u60a8\u5df2\u7ecf\u662f\u201c" + vo.getShortName() + "\u201d\u7684\u5458\u5de5\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u5176\u4ed6\u5e97\u94fa");
                log.debug("\u60a8\u5df2\u7ecf\u662f\u201c" + vo.getShortName() + "\u201d\u7684\u5458\u5de5\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u5176\u4ed6\u5e97\u94fa");
            }
            createStatusDto.setType(Integer.valueOf(1));
            createStatusDto.setRegister(Integer.valueOf(register));
            return Message.build((boolean)true).addParam("createStatusDto", (Object)createStatusDto);
        }
        merchantMemberVo.setNickName(nickname);
        merchantMemberVo.setHeadImg(headImg);
        merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_YES.getType());
        merchantMemberVo.setRole(MerchantRoleEnum.MEMBER_ROLE_EMPLOYEE.getRoleCode());
        merchantMemberVo.setCreateTime(new Date());
        merchantMemberVo.setBindTime(new Date());
        merchantMemberVo.setBindPopType(Integer.valueOf(0));
        if (this.merchantMemberMapper.selectByMerchantAndUserId(createParam.getMerchantId(), createParam.getUserId()) != null) {
            merchantMemberVo.setCreateTime(null);
            merchantMemberVo.setModifyTime(new Date());
            merchantMemberVo.setDeleteFlag(Integer.valueOf(0));
            this.merchantMemberMapper.updateByUserIdAndMerchantId(merchantMemberVo);
        } else {
            this.merchantMemberMapper.insertSelective(merchantMemberVo);
            this.getMerchantAuthService().initAuth(createParam.getMerchantId(), createParam.getUserId(), MerchantRoleEnum.MEMBER_ROLE_EMPLOYEE);
        }
        if (!Objects.equals(createParam.getPush(), 0)) {
            this.memberMessageService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOBOSS_SUCESSS);
        }
        this.memberMessageService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOEMPLOYEE_SUCESSS);
        this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, String.valueOf(merchantMemberVo.getUserId()), (Object)merchantMemberVo);
        this.redisStringAdapter.set(RedisConfig.MERCHANT_MESSAGE_KEY.copy().appendKey((Object)merchantInfo.getId()), (Object)(nickname + "\u548c\u60a8\u7ed1\u5b9a\u4e86\u4e86\u5458\u5de5\u5173\u7cfb"));
        this.memberMessageService.addLog(createParam.getMerchantId(), nickname + "\u548c\u60a8\u7ed1\u5b9a\u4e86\u4e86\u5458\u5de5\u5173\u7cfb", null);
        createStatusDto.setType(Integer.valueOf(0));
        createStatusDto.setContent("\u606d\u559c\u4f60\u6210\u4e3a" + merchantInfo.getShortName() + "\u7684\u5458\u5de5");
        return Message.build((boolean)true).addParam("createStatusDto", (Object)createStatusDto);
    }

    public void updateHeadImgAndNickName(Long userId, String headImg, String nickName) {
        this.merchantMemberMapper.updateHeadImgAndNickName(userId, headImg, nickName);
    }

    public MerchantMemberFacadeServiceImpl(RedisHashMapAdapter redisHashMapAdapter, MerchantMemberMapper merchantMemberMapper, UserInviteIntegrationService userInviteIntegrationService, UserIntegrationService userIntegrationService, MerchantInfoFacadeService merchantInfoFacadeService, MemberMessageService memberMessageService, RedisStringAdapter redisStringAdapter, MerchantMemberService merchantMemberService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.merchantMemberMapper = merchantMemberMapper;
        this.userInviteIntegrationService = userInviteIntegrationService;
        this.userIntegrationService = userIntegrationService;
        this.merchantInfoFacadeService = merchantInfoFacadeService;
        this.memberMessageService = memberMessageService;
        this.redisStringAdapter = redisStringAdapter;
        this.merchantMemberService = merchantMemberService;
    }
}

