/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.security.service.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantMemberEnum;
import com.bxm.localnews.merchant.domain.security.MerchantMemberMapper;
import com.bxm.localnews.merchant.dto.MerchantUserInfoDto;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.EmployeeRemoveParam;
import com.bxm.localnews.merchant.param.RemoveRecordParam;
import com.bxm.localnews.merchant.security.facade.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.security.facade.param.MemberTeamParam;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.security.param.MerchantMemberPageParam;
import com.bxm.localnews.merchant.security.service.MemberMessageService;
import com.bxm.localnews.merchant.security.service.MerchantMemberService;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MerchantMemberImpl
extends BaseService
implements MerchantMemberService {
    private MerchantMemberMapper merchantMemberMapper;
    private UserIntegrationService userIntegrationService;
    private RedisHashMapAdapter redisHashMapAdapter;
    private MemberMessageService memberMessageService;
    private RedisStringAdapter redisStringAdapter;
    private final MerchantInfoFacadeService merchantInfoDbService;

    @Override
    public PageWarper<MechantTeamInfosDTO> getMemberList(MemberTeamParam param) {
        List listFromDb = this.merchantMemberMapper.getMemberForIdAndNickname(param);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)listFromDb)) {
            return new PageWarper();
        }
        List<MechantTeamInfosDTO> result = listFromDb.stream().map(item -> {
            MechantTeamInfosDTO mechantTeamInfosDTO = new MechantTeamInfosDTO();
            BeanUtils.copyProperties((Object)item, (Object)mechantTeamInfosDTO);
            return mechantTeamInfosDTO;
        }).collect(Collectors.toList());
        result.forEach(bean -> {
            UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(bean.getUserId());
            if (Objects.nonNull(user)) {
                bean.setPhone(Objects.nonNull(user.getPhone()) ? user.getPhone() : null);
                bean.setAreaName(Objects.nonNull(user.getLocationName()) ? user.getLocationName() : null);
            }
        });
        return new PageWarper(result);
    }

    @Override
    public Message remove(EmployeeRemoveParam employeeRemoveParam) {
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(employeeRemoveParam.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)"\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f");
        }
        MerchantMemberVo merchantMemberVo = this.getMemberInfo(employeeRemoveParam.getUserId());
        if (merchantMemberVo == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u7ed1\u5b9a\u5e97\u94fa");
        }
        merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_NO.getType());
        merchantMemberVo.setModifyTime(new Date());
        this.merchantMemberMapper.updateByUserId(merchantMemberVo);
        this.memberMessageService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOBOSS_FAIL);
        this.memberMessageService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOEMPLOYEE_FAIL);
        this.memberMessageService.addLog(merchantMemberVo.getMerchantId(), merchantMemberVo.getNickName() + "\u548c\u60a8\u89e3\u9664\u4e86\u5458\u5de5\u5173\u7cfb", "\u89e3\u9664\u7ed1\u5b9a");
        this.redisHashMapAdapter.remove(RedisConfig.MEMBER_INFO_KEY, new String[]{merchantMemberVo.getUserId() + ""});
        this.redisStringAdapter.set(RedisConfig.MERCHANT_MESSAGE_KEY.copy().appendKey((Object)merchantMemberVo.getMerchantId()), (Object)(merchantMemberVo.getNickName() + "\u548c\u60a8\u89e3\u9664\u4e86\u5458\u5de5\u5173\u7cfb"));
        return Message.build((boolean)true);
    }

    @Override
    public Message removeRecord(RemoveRecordParam removeRecordParam) {
        if (this.merchantMemberMapper.selectByPrimaryKey(removeRecordParam.getId()) == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u6761\u7ed1\u5b9a\u8bb0\u5f55");
        }
        MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
        merchantMemberVo.setId(removeRecordParam.getId());
        merchantMemberVo.setDeleteFlag(Integer.valueOf(1));
        merchantMemberVo.setDeleteTime(new Date());
        merchantMemberVo.setModifyTime(new Date());
        this.merchantMemberMapper.updateByPrimaryKeySelective(merchantMemberVo);
        return Message.build((boolean)true);
    }

    @Override
    public PageWarper<MerchantMemberVo> getEmployeeList(MerchantMemberPageParam merchantMemberPageParam) {
        List list = this.merchantMemberMapper.queryListByPage(merchantMemberPageParam);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return new PageWarper(list);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    @Override
    public Message getMerchantUserInfo(Long userId) {
        MerchantMemberVo merchantMemberVo = this.getMemberInfo(userId);
        if (merchantMemberVo == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u56e2\u961f\u7684\u76f8\u5173\u4fe1\u606f");
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantMemberVo.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7ed1\u5b9a\u5e97\u94fa\u7684\u76f8\u5173\u4fe1\u606f");
        }
        MerchantUserInfoDto merchantUserInfoDto = new MerchantUserInfoDto();
        merchantUserInfoDto.setShortName(merchantInfo.getShortName());
        merchantUserInfoDto.setHeadImg(merchantMemberVo.getHeadImg());
        merchantUserInfoDto.setNickname(merchantMemberVo.getNickName());
        merchantUserInfoDto.setCreateTime(merchantMemberVo.getBindTime());
        return Message.build((boolean)true).addParam("merchantUserInfoDto", (Object)merchantUserInfoDto);
    }

    @Override
    public MerchantMemberVo getMemberInfo(Long userId) {
        MerchantMemberVo merchantMemberVo = (MerchantMemberVo)this.redisHashMapAdapter.get(RedisConfig.MEMBER_INFO_KEY, userId + "", MerchantMemberVo.class);
        if (merchantMemberVo == null) {
            MerchantMemberVo vo = this.merchantMemberMapper.selectByUserId(userId);
            if (vo != null) {
                this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, vo.getUserId() + "", (Object)vo);
                return vo;
            }
            return null;
        }
        return merchantMemberVo;
    }

    public MerchantMemberImpl(MerchantMemberMapper merchantMemberMapper, UserIntegrationService userIntegrationService, RedisHashMapAdapter redisHashMapAdapter, MemberMessageService memberMessageService, RedisStringAdapter redisStringAdapter, MerchantInfoFacadeService merchantInfoDbService) {
        this.merchantMemberMapper = merchantMemberMapper;
        this.userIntegrationService = userIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.memberMessageService = memberMessageService;
        this.redisStringAdapter = redisStringAdapter;
        this.merchantInfoDbService = merchantInfoDbService;
    }
}

