/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.dto.ManageMerchantInfoDto;
import com.bxm.localnews.merchant.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.dto.MerchantAuthInfoDto;
import com.bxm.localnews.merchant.param.AuditAuthInfoParam;
import com.bxm.localnews.merchant.param.ManageMerchantInfoAddParam;
import com.bxm.localnews.merchant.param.ManageMerchantInfoParam;
import com.bxm.localnews.merchant.param.MerchantAdvertParam;
import com.bxm.localnews.merchant.param.manager.MemberTeamParam;
import com.bxm.localnews.merchants.dto.MerchantAdvertInfoDTO;
import com.bxm.localnews.merchants.manage.MerchantInfoManageService;
import com.bxm.localnews.merchants.param.MerchantManageListParam;
import com.bxm.localnews.merchants.vo.MerchantInfoListVo;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"11-50  \u5546\u5bb6\u7ba1\u7406\u540e\u53f0\u5b9a\u4e49"})
@RestController
@RequestMapping(value={"/manage/merchant/info"})
public class MerchantManageController {
    @Autowired
    private MerchantInfoManageService merchantInfoManageService;

    @PostMapping(value={"/getMerchantList"})
    @ApiOperation(value="11-50-1  \u5546\u5bb6\u5217\u8868", notes="\u5546\u5bb6\u5217\u8868", httpMethod="POST")
    public ResponseJson<PageWarper<MerchantInfoListVo>> getMerchantList(@RequestBody MerchantManageListParam merchantManageListParam) {
        return ResponseJson.ok((Object)this.merchantInfoManageService.getMerchantList(merchantManageListParam));
    }

    @ApiOperation(value="11-50-2  \u67e5\u8be2\u8ba4\u8bc1\u4fe1\u606f", notes="\u67e5\u8be2\u8ba4\u8bc1\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/getAuthInfo"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true)})
    public ResponseJson<MerchantAuthInfoDto> getAuthInfo(@RequestParam(value="merchantId") Long merchantId) {
        Message message = this.merchantInfoManageService.getAuthInfo(merchantId);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("merchantAuthInfoDto"));
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-50-3  \u5ba1\u6838\u8ba4\u8bc1\u4fe1\u606f", notes="\u5ba1\u6838\u8ba4\u8bc1\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"/auditAuthInfo"})
    public ResponseJson<Boolean> auditAuthInfo(@RequestBody AuditAuthInfoParam auditAuthInfoParam) {
        Message message = this.merchantInfoManageService.auditAuthInfo(auditAuthInfoParam);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)Boolean.TRUE);
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-50-4  \u67e5\u8be2\u5e97\u94fa\u4fe1\u606f", notes="\u67e5\u8be2\u5e97\u94fa\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/getMerchantInfo"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true)})
    public ResponseJson<ManageMerchantInfoDto> getMerchantInfo(@RequestParam(value="merchantId") Long merchantId) {
        Message message = this.merchantInfoManageService.getMerchantInfo(merchantId);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("manageMerchantInfoDto"));
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-50-5  \u4fee\u6539\u5e97\u94fa\u4fe1\u606f", notes="\u4fee\u6539\u5e97\u94fa\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"/saveMerchantInfo"})
    public ResponseJson saveMerchantInfo(@RequestBody @Validated ManageMerchantInfoParam manageMerchantInfoParam) {
        Message message = this.merchantInfoManageService.saveMerchantInfo(manageMerchantInfoParam);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-50-6  \u6dfb\u52a0\u5e97\u94fa\u5907\u6ce8\u4fe1\u606f", notes="\u6dfb\u52a0\u5e97\u94fa\u5907\u6ce8\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/addMerchantRemark"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", required=true)})
    public ResponseJson<Boolean> addMerchantRemark(@RequestParam(value="merchantId") Long merchantId, @RequestParam(value="remark") String remark) {
        this.merchantInfoManageService.addMerchantRemark(merchantId, remark);
        return ResponseJson.ok((Object)Boolean.TRUE);
    }

    @ApiOperation(value="11-50-7  \u65b0\u589e\u5e97\u94fa\u4fe1\u606f", notes="\u65b0\u589e\u5e97\u94fa\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"/insertMerchantInfo"})
    public ResponseJson<Boolean> insertMerchantInfo(@RequestBody @Validated ManageMerchantInfoAddParam manageMerchantInfoAddParam) {
        Message message = this.merchantInfoManageService.insertMerchantInfo(manageMerchantInfoAddParam);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-50-8  \u5546\u5bb6\u56e2\u961f\u6210\u5458\u5217\u8868", notes="\u5546\u5bb6\u56e2\u961f\u6210\u5458\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/merchantTeam"})
    public ResponseJson<PageWarper<MechantTeamInfosDTO>> getMerchantTeamInfos(MemberTeamParam param) {
        return ResponseJson.ok((Object)this.merchantInfoManageService.getMemberInfo(param));
    }

    @ApiOperation(value="11-50-9  \u5546\u5bb6\u5e7f\u544a\u8be6\u60c5", notes="\u5546\u5bb6\u5e7f\u544a\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/merchantAdvertDetail"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", required=true)})
    public ResponseJson<MerchantAdvertInfoDTO> getMerchantAdvertDetail(@RequestParam Long merchantId) {
        return ResponseJson.ok((Object)this.merchantInfoManageService.merchantAdvertInfo(merchantId));
    }

    @ApiOperation(value="11-50-10  \u7f16\u8f91\u4fdd\u5b58\u5546\u5bb6\u5e7f\u544a", notes="\u7f16\u8f91\u4fdd\u5b58\u5546\u5bb6\u5e7f\u544a", httpMethod="POST")
    @PostMapping(value={"/merchantAdvertSave"})
    public ResponseJson<Boolean> merchantAdvertSave(@RequestBody MerchantAdvertParam param) {
        return ResponseJson.ok((Object)this.merchantInfoManageService.editMerchantAdvert(param));
    }

    @ApiOperation(value="11-50-11  \u6279\u91cf\u7ed1\u5b9a\u5458\u5de5", notes="\u6279\u91cf\u7ed1\u5b9a\u5458\u5de5", httpMethod="POST")
    @PostMapping(value={"/bindBatch"})
    public ResponseJson<Boolean> bindBatch(@RequestParam(value="multipartFile") MultipartFile multipartFile) {
        this.merchantInfoManageService.readExcel(multipartFile);
        return ResponseJson.ok((Object)Boolean.TRUE);
    }
}

