package com.bxm.localnews.merchants.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(description = "商家中心基本信息出参")
@Data
public class MerchantBusinessInfo {
    @ApiModelProperty("资质状态  0: 资质未提交 1: 资质已提待审核 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("0未装修1已装修")
    private Integer settlementStatus;

    @ApiModelProperty("0未进入过会员中心 1已进入过会员中心")
    private Integer isInCenter;

    @ApiModelProperty("可用推广金")
    private BigDecimal ablePromotionCash;

    @ApiModelProperty("0不是会员1是会员")
    private Integer isVip;

    @ApiModelProperty("0未绑定过员工1已绑定过员工")
    private Integer bindType;

    @ApiModelProperty("商家的粉丝数量，即商家这个用户的关注数量")
    private Integer fansNum;
}
