package com.bxm.localnews.merchants.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "商家基本信息出参")
@Data
public class MerchantInfoDto {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("店铺头图的json数组字符串")
    private String headPics;

    @ApiModelProperty("logo图片地址")
    private String logo;

    @ApiModelProperty("商家主图，优先选择logo，如果不存在则选择头图的第一张")
    private String masterPicture;

    @ApiModelProperty("商户一句话描述")
    private String des;

    @ApiModelProperty("商家店铺简称")
    private String shortName;

    @ApiModelProperty("'联系人名称")
    private String manageName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String countyCode;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("开放时间 0: 全天开放 1: 指定时间开放")
    private Integer openType;

    @ApiModelProperty("营业开始时间 0000 为00:00")
    private String openTime;

    @ApiModelProperty("营业结束时间 0000 为00:00")
    private String closeTime;

    @ApiModelProperty("相册图片地址的json数组集合")
    private String album;

    @ApiModelProperty("店铺详情描述")
    private String detailContent;

    @ApiModelProperty("商户行业分类名称")
    private String categoryName;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("商家绑定的用户id")
    private Long userId;
}
