package com.bxm.localnews.merchants.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(description = "后台返回商家列表出参")
@Data
//@Builder
public class MerchantMangeListDto {
    @ApiModelProperty("商家id")
    private Long id;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("申请入驻时间")
    private Date createTime;

    @ApiModelProperty("最后一次递交申请资质认证的时间")
    private Date lastAuthTime;

    @ApiModelProperty("资质状态  0: 资质未提交 1: 资质已提待审核 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("店铺可用状态 0未审核1审核上架2审核下架")
    private Integer isShelf;

    @ApiModelProperty("推广金金额")
    private BigDecimal ablePromotionCash;

    @ApiModelProperty("会员到期时间")
    private Date endTime;

    @ApiModelProperty("备注")
    private String remark;
}
