package com.bxm.localnews.merchants.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2020/11/19 15:33
 */
@Data
@Builder
public class MerchantWorkCouponDTO {

    @ApiModelProperty("领取的门槛金额（最少消费金额）")
    private BigDecimal totalAmount;

    @ApiModelProperty("优惠券的减免金额")
    private BigDecimal discount;

    @ApiModelProperty(value = "优惠券ID")
    private Long couponId;

    @ApiModelProperty("是否有金额门槛（1：有，0：无）")
    private Integer conditionAmount;
}
