package com.bxm.localnews.merchants.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: pf.w
 * @Date: 2020/7/9 14:26
 */
@ApiModel(description = "商家列表信息")
@Data
public class MerchantBasicParam extends PageParam {

    @ApiModelProperty("经度")
    private Double longitude;

    @ApiModelProperty("纬度")
    private Double latitude;

    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "地区编码")
    private String areaCode;
}
