package com.bxm.localnews.merchants.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel(description = "入驻申请信息入参")
public class MerchantIntoApplyParam {

    @ApiModelProperty(value = "商家绑定的用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "省编码", required = true)
    private String provinceCode;

    @ApiModelProperty(value = "市编码", required = true)
    private String cityCode;

    @ApiModelProperty(value = "区编码", required = true)
    private String countyCode;

    @ApiModelProperty(value = "详细地址信息", required = true)
    private String address;

    @ApiModelProperty(value = "商家名称", required = true)
    private String merchantName;

    @ApiModelProperty(value = "联系电话", required = true)
    private String mobile;

    @ApiModelProperty("关联商家id")
    private Long merchantId;
}
