package com.bxm.localnews.merchants.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;


@Data
@ApiModel(description = "后台查询商家列表入参")
public class MerchantManageListParam extends PageParam {
    @ApiModelProperty("关联商家id")
    private Long merchantId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("店铺状态 0未审核1审核上架2审核下架")
    private Integer isShelf;

    @ApiModelProperty("资质状态 0: 资质未提交 1: 资质已提待审核 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    //哪个字段
    @ApiModelProperty("提交资质时间")
    private Date lastAuthTime;

    @ApiModelProperty("创建时间，也就是商家申请入驻时间")
    private Date createTime;

    @ApiModelProperty("会员到期时间")
    private Date endTime;

    @ApiModelProperty("商家广告状态 0：未配置 | 1：已上架 | 2：已下架")
    private Integer merchantAdvertStatus;

    @ApiModelProperty("排序字段 申请时间create_time 提交资质时间last_auth_time 会员到期时间end_time")
    private String filterItem;

    @ApiModelProperty("排序0降序1升序")
    private Integer sortItem;

}
