package com.bxm.localnews.merchants.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: zhoujincheng
 * @create: 2020-08-20 16:13
 */
@Data
@ApiModel(description = "商家简要基本信息")
public class MerchantInfoSimpleVO {
    @ApiModelProperty("商家id")
    private Long id;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("商家店铺简称")
    private String shortName;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("经度")
    private BigDecimal lat;

    @ApiModelProperty("维度")
    private BigDecimal lng;
}

