/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchants.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author : jieli.xu
 * @date 2020/7/9 22:21
 * 权益信息类
 */
@Data
@ApiModel("权益类")
public class InterestsInfoDTO {

    @ApiModelProperty("商家id")
    private Long id;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @ApiModelProperty("所属行业")
    private String industryName;

    @ApiModelProperty("所属行业id")
    private Long industryId;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("推广金抵扣")
    private BigDecimal deductionMoney;

    @ApiModelProperty("实际付费")
    private BigDecimal payMoney;

    @ApiModelProperty("权益类型 0:开通会员 1：开通广告")
    private Integer interestsType;

    @ApiModelProperty("开通时间")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date createTime;

    @ApiModelProperty("到期时间")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date endTime;

    @ApiModelProperty("备注")
    private String remark;
}
