package com.bxm.localnews.merchants.dto;


import com.bxm.localnews.merchants.vo.UserForMerchantInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/7/9 15:02
 */
@Data
@ApiModel(description = "商家详情")
public class MerchantDetailDTO extends MerchantWorkBase {

    @ApiModelProperty("商家详情 图文混排，支持富文本")
    private String description;

    @ApiModelProperty("门面图")
    private List<String> facadeUrl;

    @ApiModelProperty("相册图")
    private List<String> imgUrls;

    @ApiModelProperty("是否被收藏  0：否  1：是")
    private Integer hasCollected;

    @ApiModelProperty(value = "商圈")
    private String businessArea;

    @ApiModelProperty("商家客服电话")
    private String servicePhone;

    @ApiModelProperty("关联的用户信息")
    private UserForMerchantInfo userForMerchantInfo;
}
