package com.bxm.localnews.merchants.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @Author: pf.w
 * @Date: 2020/7/16 11:36
 */
@Data
@Builder
@ApiModel("用户关联商家认证信息")
public class MerchantUserDTO {

    @Tolerate
    public MerchantUserDTO() {
    }

    /**
     * 实体的版本信息
     * 用于控制缓存是否需要更新，避免直接删除整个缓存导致缓存穿透
     * 当缓存中加载的"v"不等于"CURRENT_VERSION"，说明需要重新加载用户的缓存
     */
    public static final int CURRENT_VERSION = 2;

    /**
     * 设置初始值，缓存回写时会被覆盖
     */
    @ApiModelProperty(value = "当前对象的版本", hidden = true)
    private int v = CURRENT_VERSION;

    /**
     * 认证的商户对应的万事通用户ID
     */
    private Long userId;

    @ApiModelProperty("0: 未认证  1：已认证")
    private Integer merchantStatus;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("店铺可用状态 0未审核1审核上架2审核下架")
    private Integer isShelf;
}
