package com.bxm.localnews.merchants.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author : pf.w
 * @date : 2020/7/13 16:23
 */
@ApiModel(value = "商家列表信息")
@Data
public class MerchantWorkListDTO extends MerchantWorkBase {

    @ApiModelProperty("便民页排序 0为未配置")
    private Integer bianMinOrder = 0;

    @ApiModelProperty("便民推荐开始时间")
    private Date bianMinStartTime;

    @ApiModelProperty("便民推荐结束时间")
    private Date bianMinEndTime;

    @ApiModelProperty("频道商户列表（进入分类页）推荐位置")
    private Integer channelOrder = 0;

    @ApiModelProperty("频道商户列表（进入分类页）开始时间")
    private Date channelStartTime;

    @ApiModelProperty("频道商户列表（进入分类页）结束时间")
    private Date channelEndTime;

    @ApiModelProperty("商家头像")
    private String headImg;

    @ApiModelProperty("成为vip时间")
    private Date toVipDate;

    @ApiModelProperty("便民置顶状态 0：失效  1：正常")
    private Integer bianMinTopStatus = 0;

    @ApiModelProperty("子分类置顶状态  0：失效  1：正常")
    private Integer channelTopStatus = 0;

    @ApiModelProperty("商品列表")
    List<MerchantWorkGoodsDTO> goodsDTOList;

}
