package com.bxm.localnews.merchants.param;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@ApiModel(description = "资质申请信息入参")
public class MerchantAuthInfoParam {

    @ApiModelProperty(value = "关联商家id", required = true)
    @NotNull(message = "关联商家id不能为空")
    private Long merchantId;

    @ApiModelProperty(value = "店铺名称", required = true)
    @NotBlank(message = "店铺名称不能为空")
    private String merchantName;

    @ApiModelProperty(value = "商户行业分类id", required = true)
    @NotNull(message = "商户行业分类id不能为空")
    private Long categoryId;

    @ApiModelProperty(value = "营业执照图片地址", required = false)
    private String licensePic;

    @ApiModelProperty(value = "法人身份证正面照片",required = false )
    private String legalPersonFacePic;

    @ApiModelProperty(value = "法人身份证反面照片", required = false)
    private String legalPersonBackPic;

    @ApiModelProperty(value = "0已有营业执照  1无营业执照", required = false)
    private Integer type;

}
