package com.bxm.localnews.merchants.vo;

import com.bxm.localnews.merchants.dto.MerchantMangeListDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zhoujincheng
 * @create: 2020-07-14 15:54
 */
@Data
public class MerchantInfoListVo extends MerchantMangeListDto {
    @ApiModelProperty("商家id")
    private Long id;
    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("联系电话")
    private String mobile;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("申请入驻时间")
    private Date createTime;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("最后一次递交申请资质认证的时间")
    private Date lastAuthTime;

    @ApiModelProperty("资质状态  0: 资质未提交 1: 资质已提待审核 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("店铺可用状态 0未审核1审核上架2审核下架")
    private Integer isShelf;

    @ApiModelProperty("推广金金额")
    private BigDecimal ablePromotionCash;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("会员到期时间")
    private Date endTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("0有营业执照1无营业执照")
    private Integer businessLicenseType;

    @ApiModelProperty("商家广告状态 0：未配置 | 1：已上架 | 2：已下架")
    private Integer merchantAdvertStatus;

    @ApiModelProperty("商家成员数")
    private Integer merchantTeamNum;

    @ApiModelProperty("付费金额")
    private BigDecimal payCash;

    @ApiModelProperty("商品数")
    private Integer goodsNum;

    @ApiModelProperty("账户可用余额")
    private BigDecimal ableCash;



}
