/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.message.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.message.dto.MessageNumVo;
import com.bxm.localnews.message.param.MessageListParam;
import com.bxm.localnews.message.service.MessageService;
import com.bxm.localnews.message.service.MessageUserService;
import com.bxm.localnews.message.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-01 \u7528\u6237\u6d88\u606f\u5217\u8868"}, description="\u83b7\u53d6\u7528\u6237\u7684\u672a\u8bfb\u6d88\u606f")
@RestController
@RequestMapping(value={"api/msg"})
public class MessageController {
    @Resource
    private MessageService messageService;
    @Resource
    private MessageUserService messageUserService;

    @ApiOperation(value="5-01-1 \u83b7\u53d6\u7528\u6237\u6d88\u606f\u5217\u8868", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"list"}, method={RequestMethod.GET})
    public Json<PageWarper<Message>> getList(@Validated MessageListParam messageListParam) {
        return Json.build((Object)this.messageService.listMessage(messageListParam));
    }

    @ApiOperation(value="5-01-2 \u83b7\u53d6\u6700\u65b0\u6d88\u606f\u6761\u6570", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"newMsg"}, method={RequestMethod.GET})
    public Json<MessageNumVo> getNewMsg(@RequestParam(value="userId") Long userId) {
        int num = this.messageService.getNewMsg(userId);
        MessageNumVo messageNumVo = new MessageNumVo();
        messageNumVo.setNum(num);
        return ResultUtil.genSuccessResult((Object)messageNumVo);
    }

    @ApiOperation(value="5-01-3 \u6e05\u7a7a\u6d88\u606f", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"delete"}, method={RequestMethod.GET})
    public Json updateById(@RequestParam(value="userId") Long userId) {
        return this.messageUserService.updateById(userId);
    }

    @ApiOperation(value="5-01-4 \u66f4\u65b0\u6d88\u606f\u4e3a\u5df2\u8bfb/\u5220\u9664", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001\u503c", required=true)})
    @RequestMapping(value={"read/delete"}, method={RequestMethod.GET})
    public Json updateById(@RequestParam(value="userId") Long userId, @RequestParam(value="id") Integer id, @RequestParam(value="status") Byte status) {
        return this.messageUserService.updateOrDelete(id, status, userId);
    }

    @ApiOperation(value="5-01-5 \u516c\u544a\u5217\u8868", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"notice/list"}, method={RequestMethod.GET})
    public Json<List<Message>> notices(@RequestParam(value="userId", required=false) Long userId, MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List list = this.messageService.queryNoticeList(userId, page);
        return ResultUtil.genSuccessResultWithPage((Object)list, (MPage)page);
    }

    @ApiOperation(value="5-01-6 \u516c\u544a\u8be6\u60c5", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true)})
    @RequestMapping(value={"notice/detail"}, method={RequestMethod.GET})
    public Json<Message> noticeDetail(@RequestParam(value="id", required=false) Integer id, @RequestParam(value="userId", required=false) Long userId) {
        this.messageUserService.updateOrDelete(id, Byte.valueOf((byte)1), userId);
        Message msg = this.messageService.noticeDetail(id);
        return ResultUtil.genSuccessResult((Object)msg);
    }
}

