package com.bxm.localnews.message.controller.facade;

import com.bxm.localnews.message.service.MessageUserService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/3/7 17:15
 * @desc
 */
@Api(tags = "5-90 用户消息列表", description = "获取用户的消息")
@RestController
@RequestMapping("/facade/msg")
public class MessageFacadeController {

    @Autowired
    private MessageUserService messageUserService;

    @ApiOperation(value = "5-90-1 计算用户消息的总数，在个人中心显示", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "/number", method = RequestMethod.GET)
    public ResponseEntity<Integer> countTotalMsg(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(messageUserService.countTotalMsg(userId));
    }
}
