package com.bxm.localnews.message.service;

import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.message.param.MessageListParam;
import com.bxm.localnews.message.param.MessageParam;
import com.bxm.localnews.message.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
public interface MessageService {

    /**
     * 获取用户最新消息总数
     *
     * @param userId
     * @return 消息总数
     */
    int getNewMsg(Long userId);

    List<Message> queryList(Long userId, MPage page);

    List<Message> queryMessageList(Map<String, Object> map);

    /**
     * 消息详情
     *
     * @param id
     * @return
     */
    Message selectByPrimaryKey(Long id);

    /**
     * 新增消息
     *
     * @param record
     * @return
     */
    int insertSelective(Message record);

    List<Message> queryList(String userId);

    /**
     * 查询消息
     *
     * @param messageParam 消息参数
     * @return 分页结果
     */
    PageWarper<Message> queryMessages(MessageParam messageParam);

    /**
     * 更新消息
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(Message record);

    /**
     * 删除消息
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    Message selectByMap(Map<String, Object> map);

    Message selectLastOne();

    List<Message> queryNoticeList(Long userId, MPage page);

    Message noticeDetail(Integer id);

    PageWarper<Message> listMessage(MessageListParam messageListParam);

    int saveMsg(Message msg);
}
