package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.mq.consume.service.MessageService;
import com.bxm.localnews.mq.consume.service.MessageUserService;
import com.bxm.localnews.msg.dto.MessageNumDTO;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "5-01 用户消息列表", description = "获取用户的未读消息")
@RestController
@RequestMapping("api/msg")
public class MessageController {

    @Resource
    private MessageService messageService;

    @Resource
    private MessageUserService messageUserService;

    @ApiOperation(value = "5-01-1 根据类型获取用户消息列表", notes = "根据msgType获取所有的消息列表,type:INTERACTION(互动消息)、" +
            "SYSTEM(系统通知)、NEWS(热闻)、BALANCE(余额)、COMMENT(评论)、LIKE(点赞)、SHARE(分享)、INVITE(邀请)")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "list", method = RequestMethod.GET)
    public Json<PageWarper<Message>> getList(@Validated MessageListParam messageListParam, BasicParam basicParam) {
        return Json.build(this.messageService.listMessage(messageListParam, basicParam));
    }

    @ApiOperation(value = "5-01-2 获取最新消息条数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "platform", value = "平台类型", required = true)
    })
    @RequestMapping(value = "newMsg", method = RequestMethod.GET)
    public Json<MessageNumDTO> getNewMsg(@RequestParam(value = "userId") Long userId,
                                         @RequestParam(value = "platform") Integer platform) {
        int num = this.messageService.getUnReadMsg(userId, platform);
        MessageNumDTO messageNumDTO = new MessageNumDTO();
        messageNumDTO.setNum(num);
        return ResultUtil.genSuccessResult(messageNumDTO);
    }

    @ApiOperation(value = "5-01-3 清空消息")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public Json updateById(@RequestParam(value = "userId") Long userId) {
        return this.messageUserService.updateById(userId);
    }

    @ApiOperation(value = "5-01-4 更新消息为已读/删除", notes = "根据msgType获取所有的消息列表,type:INTERACTION(互动消息)、" +
            "SYSTEM(系统通知)、NEWS(热闻)、BALANCE(余额)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "消息id", required = false),
            @ApiImplicitParam(name = "status", value = "状态值", required = true),
            @ApiImplicitParam(name = "messageType", value = "消息类型", required = true)
    })
    @RequestMapping(value = "read/delete", method = RequestMethod.GET)
    public Json updateById(@RequestParam(value = "userId") Long userId,
                           @RequestParam(value = "id", required = false) Integer id,
                           @RequestParam(value = "status") Byte status,
                           @RequestParam(value = "messageType") String messageType) {
        return this.messageUserService.updateOrDelete(id, status, userId, messageType);
    }

    @ApiOperation(value = "5-01-5 公告列表(已废弃)")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "notice/list", method = RequestMethod.GET)
    @Deprecated
    public Json<List<Message>> notices(@RequestParam(value = "userId", required = false) Long userId, MPage page) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "5-01-6 公告详情(已废弃)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "messageType", value = "消息类型")
    })
    @RequestMapping(value = "notice/detail", method = RequestMethod.GET)
    @Deprecated
    public Json<Message> noticeDetail(@RequestParam(value = "id", required = false) Integer id,
                                      @RequestParam(value = "userId", required = false) Long userId,
                                      @RequestParam(value = "messageType", required = false) String messageType) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "5-01-7 获取消息类型及其广告列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户id", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "type", method = RequestMethod.GET)
    public Json<MessageTypeDTO> getMessageTypes(@RequestParam("areaCode") String areaCode,
                                                @RequestParam("userId") Long userId, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(this.messageService.getMessageType(areaCode, userId, basicParam));
    }
}

