package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.consume.service.PushMessageRelationUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/1/16 14:43
 * @desc
 */
@Api(tags = "5-03 用户消息列表", description = "推送消息后的相关回调操作")
@RestController
@RequestMapping("api/public/push/message")
public class PushMessageController {

    private final PushMessageRelationUserService pushMessageRelationUserService;

    @Autowired
    public PushMessageController(PushMessageRelationUserService pushMessageRelationUserService) {
        this.pushMessageRelationUserService = pushMessageRelationUserService;
    }

    @ApiOperation(value = "5-03-1 更新用户查阅消息后的状态", notes = "用户查看推送消息后反馈查看结果")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "messageId", value = "消息id", required = true)
    })
    @RequestMapping(value = "checked", method = RequestMethod.POST)
    public Json updateById(@RequestParam(value = "userId") Long userId,
                           @RequestParam(value = "messageId") Long messageId) {
        pushMessageRelationUserService.updateMessageChecked(userId, messageId);

        return ResultUtil.genSuccessResult();
    }
}
