package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.msg.dto.MessageNumDTO;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.localnews.msg.vo.UserMessageBean;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "5-01 用户消息列表", description = "用户消息中心相关服务")
@RestController
@RequestMapping("api/msg")
public class MessageController {

    @Resource
    private UserMessageService userMessageService;

    @ApiOperation(value = "5-01-1 根据类型获取用户消息列表", notes = "根据msgType获取所有的消息列表,type:INTERACTION(互动消息)、" +
            "SYSTEM(系统通知)、" +
            "NEWS(热闻)、" +
            "BALANCE(余额)、" +
            "COMMENT(评论)、" +
            "LIKE(点赞)、" +
            "SHARE(分享)、" +
            "INVITE(邀请)")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @GetMapping(value = "list")
    public Json<PageWarper<UserMessageBean>> getList(@Validated MessageListParam messageListParam, BasicParam basicParam) {
        return Json.build(this.userMessageService.listMessage(messageListParam, basicParam));
    }

    @ApiOperation(value = "5-01-7 [废弃]获取消息类型及其广告列表", notes = "使用5-04-1接口代替")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "userId", value = "用户id", paramType = "query", dataType = "String")
    })
    @GetMapping(value = "type")
    @Deprecated
    public Json<MessageTypeDTO> getMessageTypes(@RequestParam("areaCode") String areaCode,
                                                @RequestParam("userId") Long userId, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(this.userMessageService.getMessageType(areaCode, userId, basicParam));
    }

    @ApiOperation(value = "5-01-2 获取最新消息条数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "platform", value = "平台类型", required = true),
            @ApiImplicitParam(name = "curVer", value = "当前客户端版本")
    })
    @GetMapping(value = "newMsg")
    public Json<MessageNumDTO> getNewMsg(@RequestParam(value = "userId") Long userId,
                                         @RequestParam(value = "platform") Integer platform,
                                         @RequestParam(value = "curVer") String curVer) {
        int num = this.userMessageService.getUnReadMsg(userId, platform, curVer);
        MessageNumDTO messageNumDTO = new MessageNumDTO();
        messageNumDTO.setNum(num);
        return ResultUtil.genSuccessResult(messageNumDTO);
    }

    @ApiOperation(value = "5-01-3 清空消息")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @GetMapping(value = "delete")
    public Json updateById(@RequestParam(value = "userId") Long userId) {
        /**
         * V3.4.0 该方法已废弃，防止客户端仍然有调用，继续保留
         */
        return Json.build();
    }

    @ApiOperation(value = "5-01-4 更新消息为已读", notes = "将消息类目或会话的未读消息数量设置为0")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "消息id[已废弃，不需要传递]"),
            @ApiImplicitParam(name = "status", value = "状态值[已废弃，不需要传递]"),
            @ApiImplicitParam(name = "messageType", value = "消息类型或会话ID", required = true)
    })
    @GetMapping(value = "read/delete")
    public Json updateById(@RequestParam(value = "userId") Long userId,
                           @RequestParam(value = "id", required = false) Integer id,
                           @RequestParam(value = "status", required = false) Byte status,
                           @RequestParam(value = "messageType") String messageType) {
        userMessageService.updateMessageByType(userId, messageType);
        return Json.build();
    }

    @ApiOperation(value = "5-01-5 公告列表(已废弃)", hidden = true)
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @GetMapping(value = "notice/list")
    @Deprecated
    public Json<List<UserMessageBean>> notices(@RequestParam(value = "userId", required = false) Long userId, MPage page) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "5-01-6 公告详情(已废弃)", hidden = true)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "messageType", value = "消息类型")
    })
    @GetMapping(value = "notice/detail")
    @Deprecated
    public Json<UserMessageBean> noticeDetail(@RequestParam(value = "id", required = false) Integer id,
                                              @RequestParam(value = "userId", required = false) Long userId,
                                              @RequestParam(value = "messageType", required = false) String messageType) {
        return ResultUtil.genSuccessResult();
    }
}

