package com.bxm.localnews.mq.common.constant;

import com.bxm.newidea.component.tools.NumberUtils;

import static com.bxm.localnews.mq.common.constant.MessageBehaviorEnum.JUMP;
import static com.bxm.localnews.mq.common.constant.MessageBehaviorEnum.UN_JUMP;

/**
 * 推送消息
 */
public enum PushMessageEnum {

    SYSTEM_MSG(0, "系统公告", UN_JUMP, Boolean.FALSE),
    ORDINARY_MSG(1, "提示消息", UN_JUMP, Boolean.FALSE),
    NEWS(9, "新闻", JUMP, Boolean.FALSE),
    OPEN_URL(10, "打开链接", JUMP, Boolean.FALSE),
    PARTICIPATE_PRIVILEGE_SUCCESS(11, "参加活动成功", JUMP, Boolean.FALSE),
    PRIVILEGE_OPEN_PRIZE(12, "活动开奖", JUMP, Boolean.FALSE),
    PRIVILEGE_WINNING(13, "活动中奖", JUMP, Boolean.FALSE),
    TASK_COMPLETED(15, "任务完成（日常/新手）", UN_JUMP, Boolean.TRUE),
    NEW_MERCHANT(16, "商家提交信息成功", UN_JUMP, Boolean.FALSE),
    MERCHANT_VERIFY(18, "商家审核失败", UN_JUMP, Boolean.FALSE),

    VIP_FRIEND_HELP(30, "用户激活vip时好友助力", JUMP, Boolean.FALSE),
    VIP_ACTIVATION_SUCCESS(31, "用户激活vip", JUMP, Boolean.FALSE);

    private int type;

    private String desc;

    //是否需要跳转
    private MessageBehaviorEnum behavior;

    //是否静默推送（无通知栏）
    private Boolean silence;

    PushMessageEnum(int type, String desc, MessageBehaviorEnum behavior, Boolean silence) {
        this.type = type;
        this.desc = desc;
        this.behavior = behavior;
        this.silence = silence;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getDesc();
            }
        }
        return null;
    }

    public static String getMessageDescByType(String type) {
        return getMessageDescByType(NumberUtils.parseToInt(type));
    }

    public static MessageBehaviorEnum getMessageBehaviorByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getBehavior();
            }
        }
        return null;
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getSilence();
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public MessageBehaviorEnum getBehavior() {
        return behavior;
    }

    public Boolean getSilence() {
        return silence;
    }
}
