package com.bxm.localnews.mq.common.constant;

/**
 * 推送消息接受者规则枚举（特殊自定义规则枚举，如根据手机型号、待唤醒时间等特殊条件）
 */
public enum PushReceiverRuleEnum {

    /**
     * 用户区域推送，需要提供额外参数
     * ReceiverRuleParamConstant.AREA_CODES:用户区域列表
     */
    AREA,

    /**
     * 用户全量推送，慎用!!!!
     */
    ALL,

    /**
     * 默认策略
     * ReceiverRuleParamConstant.USER_IDS:用户区域列表
     */
    DEFAULT,

    /**
     * 区域vip相关推送，需要提供额外参数
     * ReceiverRuleParamConstant.VIP: vip状态
     */
    VIP_AREA,

    /**
     * 用户vip相关推送，需要提供额外参数
     * ReceiverRuleParamConstant.VIP: vip状态
     */
    VIP_USER;
}
