package com.bxm.localnews.mq.common.model.dto;

import com.bxm.localnews.mq.common.constant.PushFoldTypeEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.BaseBean;

/**
 * 推送到客户端消息（个推）
 *
 * @author liujia 2018/8/15 11:26
 */
public class PushMessage extends BaseBean {

    /**
     * 显示在通知栏的标题
     */
    private String title;

    /**
     * 显示内容
     */
    private String content;

    /**
     * 是否静音（收到消息不提示声音）
     */
    private boolean mute = false;

    /**
     * 接收到消息时的提示音（如果mute设置为true则此设置无效）
     */
    private PushSoundEnum sound = PushSoundEnum.DEFAULT_SOUND;

    /**
     * 推送消息类型(默认为通知)
     */
    private TemplateTypeEnum type = TemplateTypeEnum.NOTIFCTION;

    /**
     * 额外的承载信息
     * 根据具体的业务消息类型增加对应的参数
     */
    private PushPayloadInfo payloadInfo = PushPayloadInfo.build();

    /**
     * 是否持久化消息（是否将推送的消息同时写入到对应用户的个人消息中）
     */
    private boolean persistence = true;

    /**
     * 接收推送消息的用户范围定义
     */
    private PushReceiveScope pushReceiveScope;

    /**
     * 是否浮动通知
     */
    private boolean floatNotify;

    /**
     * 展开通知方式
     */
    private PushFoldTypeEnum pushFoldType;

    /**
     * 展开式通知图片路径
     */
    private String notifyImageUrl;

    /**
     * 展开式通知文本
     */
    private String notifyText;

    /**
     * 消息有效期（单位：小时）
     * 默认24小时
     */
    private Integer periodTime = 24;

    /**
     * 是否震动
     */
    private boolean isShock;

    /**
     * 推送后的动作
     */
    private Byte actionType = 1;

    private PushMessage(String title, String content) {
        this.title = title;
        this.content = content;
    }

    private PushMessage() {

    }

    public static PushMessage build() {
        return new PushMessage();
    }

    public PushReceiveScope getPushReceiveScope() {
        return pushReceiveScope;
    }

    /**
     * 设置消息的接收范围
     *
     * @param pushReceiveScope 消息接收范围
     * @return 推送消息对象
     */
    public PushMessage setPushReceiveScope(PushReceiveScope pushReceiveScope) {
        this.pushReceiveScope = pushReceiveScope;
        return this;
    }

    public boolean isShock() {
        return isShock;
    }

    public void setShock(boolean shock) {
        isShock = shock;
    }

    public Integer getPeriodTime() {
        return periodTime;
    }

    public void setPeriodTime(Integer periodTime) {
        this.periodTime = periodTime;
    }

    public boolean isFloatNotify() {
        return floatNotify;
    }

    public void setFloatNotify(boolean floatNotify) {
        this.floatNotify = floatNotify;
    }

    public PushFoldTypeEnum getPushFoldType() {
        return pushFoldType;
    }

    public void setPushFoldType(PushFoldTypeEnum pushFoldType) {
        this.pushFoldType = pushFoldType;
    }

    public String getNotifyImageUrl() {
        return notifyImageUrl;
    }

    public void setNotifyImageUrl(String notifyImageUrl) {
        this.notifyImageUrl = notifyImageUrl;
    }

    public String getNotifyText() {
        return notifyText;
    }

    public void setNotifyText(String notifyText) {
        this.notifyText = notifyText;
    }

    public boolean isPersistence() {
        return persistence;
    }

    public PushMessage setPersistence(boolean persistence) {
        this.persistence = persistence;
        return this;
    }

    public PushSoundEnum getSound() {
        return this.sound;
    }

    public PushMessage setSound(PushSoundEnum sound) {
        this.sound = sound;
        return this;
    }

    public boolean isMute() {
        return this.mute;
    }

    public PushMessage setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public TemplateTypeEnum getType() {
        return this.type;
    }

    public PushMessage setType(TemplateTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PushMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public PushPayloadInfo getPayloadInfo() {
        if (null == this.payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        }

        //同步消息信息到消息发送主体
        if (StringUtils.isBlank(payloadInfo.getTitle())) {
            payloadInfo.setTitle(getTitle());
        }
        if (StringUtils.isBlank(payloadInfo.getContent())) {
            payloadInfo.setContent(getContent());
        }
        if (null != getSound()) {
            payloadInfo.setSound(getSound().name());
        }
        return this.payloadInfo;
    }

    public PushMessage setPayloadInfo(PushPayloadInfo payloadInfo) {
        if (null == payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        } else {
            this.payloadInfo = payloadInfo;
        }
        return this;
    }

    public Byte getActionType() {
        return actionType;
    }

    public void setActionType(Byte actionType) {
        this.actionType = actionType;
    }

    /**
     * 验证当前消息是否正确
     *
     * @return true表示消息格式正确
     */
    public boolean valid() {
        return pushReceiveScope != null && payloadInfo != null;
    }
}
