package com.bxm.localnews.mq.common.constant;

/**
 * 消息推送涉及到的各种平台，不仅包括APP，也包括小程序、公众号等
 */
public enum PlatformTypeEnum {

    /**
     * 个推
     */
    GETUI(1, true, "个推"),

    /**
     * 华为
     */
    HUAWEI(2, true, "华为"),

    /**
     * 小米
     */
    MIUI(3, true, "小米"),

    /**
     * 友盟
     */
    UMENG(4, true, "友盟"),

    /**
     * vivo
     */
    VIVO(5, true, "VIVO"),

    /**
     * oppo
     */
    OPPO(6, true, "OPPO"),

    /**
     * 微信公众号
     */
    WECHAT_MP(7, false, "公众号"),

    /**
     * 手机号码
     */
    PHONE(8, false, "手机号码"),

    /**
     * 空平台
     */
    NONE(99, false, "未定义");

    /**
     * 推送平台是否为APP，暂时只有app走push
     */
    private boolean app;

    /**
     * 推送平台的token类型编码
     */
    private byte code;

    private String label;

    PlatformTypeEnum(int code, boolean app, String label) {
        this.code = (byte) code;
        this.app = app;
        this.label = label;
    }

    public static PlatformTypeEnum getByCode(byte code) {
        for (PlatformTypeEnum value : PlatformTypeEnum.values()) {
            if (code == value.code) {
                return value;
            }
        }

        return NONE;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isApp() {
        return app;
    }

    public byte getCode() {
        return code;
    }
}
