package com.bxm.localnews.mq.common.model.dto;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 自定义短信发送参数
 *
 * @author Arei on 2018/12/3.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class SmsSendParam extends BaseBean {

    /**
     * 短信接收号码
     */
    private String phoneNo;

    /**
     * 批量发送时的接收号码
     */
    private List<String> phoneNos;

    /**
     * 占位符短信的替换内容，与短信中的占位符一致
     */
    private String[] params;

    /**
     * 短信模板
     */
    private SmsTemplateEnum smsTemplateEnum;

    /**
     * 短信发送请求来源IP
     */
    private String ip;

    /**
     * 短信内容，根据短信模板类型不同有所区分
     */
    private String content;
}
