package com.bxm.localnews.mq.common.constant;

/**
 * 推送消息接受者规则枚举（特殊自定义规则枚举，如根据手机型号、待唤醒时间等特殊条件）
 */
public enum PushReceiverRuleEnum {

    /**
     * 默认策略，明确指定单个用户或多个用户
     * ReceiverRuleParamConstant.USER_IDS:用户区域列表
     */
    DEFAULT,

    /**
     * 根据条件选择接受推送对象
     * 具体的筛选条件根据map参数进行传递
     */
    CONDITION,

    /**
     * 用户区域推送，需要提供额外参数
     * ReceiverRuleParamConstant.AREA_CODES:用户区域列表
     *
     * @deprecated 业务绑定过于紧密，废弃使用
     */
    @Deprecated
    AREA,

    /**
     * 用户全量推送，慎用!!!!
     *
     * @deprecated 风险过高，无应用场景，不再支持
     */
    @Deprecated
    ALL,

    /**
     * 区域vip相关推送，需要提供额外参数
     * ReceiverRuleParamConstant.VIP: vip状态
     *
     * @deprecated 业务绑定过于紧密，废弃使用
     */
    @Deprecated
    VIP_AREA,

    /**
     * 用户vip相关推送，需要提供额外参数
     * ReceiverRuleParamConstant.VIP: vip状态
     *
     * @deprecated 业务绑定过于紧密，废弃使用
     */
    @Deprecated
    VIP_USER;
}
