package com.bxm.localnews.mq.common.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 
 */
@Data
public class UserRecommendDTO implements Serializable {

    /**
     * 用户推荐消息类型
     */
    private String recommendType;
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 出生日期
     */
    private Date birth;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * 家乡地区编码
     */
    private String hometownCode;

    /**
     * 当前地区编码
     */
    private String locationCode;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 最后发帖时间
     */
    private Date lastPostTime;

    /**
     * 最后发贴id
     */
    private Long lastPostId;

    /**
     * 最后发小纸条id
     */
    private Long lastNoteId;

    /**
     * 最后评论时间
     */
    private Date lastCommentTime;

    /**
     * 最后发小纸条时间
     */
    private Date lastNoteTime;

    /**
     * 最后聊天时间
     */
    private Date lastChatTime;

    /**
     * 资料完整度
     */
    private Integer infoCompletePercent;

    /**
     * 权重
     */
    private Integer weight;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 当前地理位置坐标
     */
    private byte[] userPosition;

    /**
     * 行业种类
     */
    private Integer jobCategory;

    /**
     * 当前定位位置地区编码
     */
    private String currentAreaCode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    private static final long serialVersionUID = 1L;

}