package com.bxm.localnews.mq.common.param;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Map;

/**
 * 用户分页查询参数，用于查询符合条件的用户用于推送
 *
 * @author liujia
 * @date 2020-07-04 14:57
 **/
@Data
@Builder
public class UserSearchPageParam {

    @Tolerate
    public UserSearchPageParam() {
    }

    /**
     * 用户接收范围自定义规则类型
     */
    private PushReceiverRuleEnum pushReceiverRule;

    /**
     * 自定义规则对应的参数
     */
    private Map<String, Object> ruleParam;

    /**
     * 分页查询参数，当前是第几页,min[1]
     */
    private Integer pageNum = 1;

    /**
     * 分页查询参数，每页显示数量,默认为10,rang[1,200]
     */
    private Integer pageSize = 10;
}
