package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.mq.produce.service.SmsSupplyService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by Arei on 2018/12/3.
 */
@RestController
@RequestMapping("/sms")
public class SmsSupplyController {
    @Resource
    private SmsSupplyService smsSupplyService;

    @PostMapping("/tml")
    public SendSmsResult sendSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        String phoneNo = smsSupplyDTO.getPhoneNo();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String ip = smsSupplyDTO.getIp();
        String[] params = smsSupplyDTO.getParams();
        return smsSupplyService.sendSmsByTemplate(phoneNo, smsTemplate, ip, params);
    }

    @PostMapping("/group/tml")
    public void sendGroupSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        List<String> phoneNos = smsSupplyDTO.getPhoneNos();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String[] params = smsSupplyDTO.getParams();
        smsSupplyService.sendGroupSmsByTemplate(phoneNos, smsTemplate, params);
    }

    @PostMapping("/custom")
    public SendSmsResult sendSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return smsSupplyService.sendSmsByCustomize(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getContent());
    }

    @PostMapping("/group/custom")
    public void sendGroupSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        smsSupplyService.sendGroupSmsByCustomize(smsSupplyDTO.getPhoneNos(), smsSupplyDTO.getContent());
    }

    @PostMapping("/tml/vcode")
    public SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return smsSupplyService.sendSmsByVCodeTemplate(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getSmsTemplateEnum(), smsSupplyDTO.getIp());
    }

    @GetMapping("/verify")
    public Boolean verifySmsCode(@RequestParam("phoneNo") String phoneNo,
                                 @RequestParam("code") String code,
                                 @RequestParam("smsTemplate") SmsTemplateEnum smsTemplate) {
        return smsSupplyService.verifySmsCode(phoneNo, code, smsTemplate);
    }

    @GetMapping("/verify/type")
    public Boolean verifySmsCodeByType(@RequestParam("type") Byte type,
                                       @RequestParam("phoneNo") String phoneNo,
                                       @RequestParam("code") String code) {
        return smsSupplyService.verifySmsCodeByType(type, phoneNo, code);
    }
}
