package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.produce.service.PushMsgSupplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "1-2 客户端消息推送")
@RestController
@RequestMapping("/push")
public class PushMsgSupplyController {
    @Resource
    private PushMsgSupplyService pushMsgSupplyService;

    @ApiOperation(value = "1-2-1 推送消息到客户端")
    @PostMapping
    public void pushMsg(@RequestBody PushMessage message) {
        pushMsgSupplyService.pushMsg(message);
    }
}
