package com.bxm.localnews.msg.dto;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "定位返回包装类")
public class LocationDTO {

    @ApiModelProperty("地区编码")
    private String code;

    @ApiModelProperty("地区简称")
    private String name;

    @ApiModelProperty("是否热门城市（1表示true）")
    private Byte hot;

    @ApiModelProperty("城市级别（2：市、3：县（区））")
    private Byte level;

    @ApiModelProperty("经度")
    private Double lng;

    @ApiModelProperty("纬度")
    private Double lat;

    @ApiModelProperty("该地区是否开启vip")
    private Byte enableVip;

    @ApiModelProperty("激活VIP需要邀请人数")
    private Integer invitedCount;

    @ApiModelProperty("地区优惠金额")
    private String reductionAmount;

    @ApiModelProperty("该地区是否开启推广赚钱")
    private Byte enablePaidPromote;

    @ApiModelProperty("新人红包")
    private BigDecimal newRedPacket;

    @ApiModelProperty("推广赏金")
    private BigDecimal promoteBounty;

    @ApiModelProperty(value = "是否启用社区内容，1：启用，0：禁用")
    private Integer enableCommunityContent;

    @ApiModelProperty(value = "是否启用首页发帖，1：启用，0：禁用")
    private Integer enableIndexPublish;

    @ApiModelProperty(value = "是否启用客服小助手，1：启用，0：禁用")
    private Integer enableCustomerService;

    public Byte getEnablePaidPromote() {
        return enablePaidPromote;
    }

    public void setEnablePaidPromote(Byte enablePaidPromote) {
        this.enablePaidPromote = enablePaidPromote;
    }

    public BigDecimal getNewRedPacket() {
        return newRedPacket;
    }

    public void setNewRedPacket(BigDecimal newRedPacket) {
        this.newRedPacket = newRedPacket;
    }

    public BigDecimal getPromoteBounty() {
        return promoteBounty;
    }

    public void setPromoteBounty(BigDecimal promoteBounty) {
        this.promoteBounty = promoteBounty;
    }

    public Byte getEnableVip() {
        return enableVip;
    }

    public void setEnableVip(Byte enableVip) {
        this.enableVip = enableVip;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public Byte getLevel() {
        return level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Integer getInvitedCount() {
        return invitedCount;
    }

    public void setInvitedCount(Integer invitedCount) {
        this.invitedCount = invitedCount;
    }

    public String getReductionAmount() {
        return reductionAmount;
    }

    public void setReductionAmount(String reductionAmount) {
        this.reductionAmount = reductionAmount;
    }

    public Integer getEnableCommunityContent() {
        return enableCommunityContent;
    }

    public void setEnableCommunityContent(Integer enableCommunityContent) {
        this.enableCommunityContent = enableCommunityContent;
    }

    public Integer getEnableIndexPublish() {
        return enableIndexPublish;
    }

    public void setEnableIndexPublish(Integer enableIndexPublish) {
        this.enableIndexPublish = enableIndexPublish;
    }

    public Integer getEnableCustomerService() {
        return enableCustomerService;
    }

    public void setEnableCustomerService(Integer enableCustomerService) {
        this.enableCustomerService = enableCustomerService;
    }
}
