package com.bxm.localnews.msg.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * Created by Administrator on 2018/2/23.
 * 用户信息
 */
@ApiModel(description = "用户实体返回包装类")
public class UserInfoDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("年龄")
    private int age;

    @ApiModelProperty("性别")
    private byte sex;

    @ApiModelProperty("等级")
    private byte level;

    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("用户访问凭证")
    private String token;

    private long expireTime;

    private String refreshToken;

    private Byte isNew;

    /**
     * 三方是否已绑定 0，未绑定 ；1：已绑定
     */
    private String weibo;

    private String qq;

    private String weixin;

    private Byte state;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    private String phone;

    @ApiModelProperty("生日(精确到日)")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_YEAR_MONTH_DAY_FORMAT)
    private Date birthday;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty(value = "用户是否使用的临时昵称 ps：0代表不能修改昵称了")
    private Byte isTempNickName;

    @ApiModelProperty("注册来源")
    private String registerChannel;

    public String getRegisterChannel() {
        return registerChannel;
    }

    public void setRegisterChannel(String registerChannel) {
        this.registerChannel = registerChannel;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public byte getSex() {
        return this.sex;
    }

    public void setSex(byte sex) {
        this.sex = sex;
    }

    public byte getLevel() {
        return this.level;
    }

    public void setLevel(byte level) {
        this.level = level;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getWeibo() {
        return this.weibo;
    }

    public void setWeibo(String weibo) {
        this.weibo = weibo;
    }

    public String getQq() {
        return this.qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getWeixin() {
        return this.weixin;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public Byte getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Byte isNew) {
        this.isNew = isNew;
    }

    public Byte getState() {
        return this.state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public void setLevelName() {
        this.levelName = "白丁";
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Byte getIsTempNickName() {
        return isTempNickName;
    }

    public void setIsTempNickName(Byte isTempNickName) {
        this.isTempNickName = isTempNickName;
    }
}
