package com.bxm.localnews.msg.facade;

import com.bxm.localnews.msg.dto.AdvertDTO;
import com.bxm.localnews.msg.facade.fallback.AdvertFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhaoyadong 2019/4/9 10:44
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = AdvertFallbackFactory.class)
public interface AdvertFeignService {

    @GetMapping("/facade/advert/type")
    ResponseEntity<List<AdvertDTO>> getAdvertsByType(@RequestParam("type") String type,
                                                     @RequestParam(value = "areaCode", required = false) String areaCode,
                                                     @RequestParam(value = "userId", required = false) Long userId);
}
