package com.bxm.localnews.msg.facade;

import com.bxm.localnews.msg.facade.fallback.NewsSyncFallbackFactory;
import com.bxm.localnews.msg.param.VideoBlackParam;
import com.bxm.localnews.msg.param.VideoShareParam;
import com.bxm.localnews.msg.param.VideoViewParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = NewsSyncFallbackFactory.class)
public interface NewsFeignService {

    @PostMapping("facade/video/statistic/black")
    void videoBlackConsume(@RequestBody VideoBlackParam videoBlackParam);

    @PostMapping("facade/video/statistic/share")
    void videoShareConsume(@RequestBody VideoShareParam videoShareParam);

    @PostMapping("facade/video/statistic/view")
    void videoViewConsume(@RequestBody VideoViewParam videoViewParam);


    @PostMapping("facade/video/statistic/comment")
    void videoCommentConsume(@RequestParam("userId") Long userId,
                             @RequestParam(value = "newsId") Long newsId);

}
