package com.bxm.localnews.msg.facade;

import com.bxm.localnews.msg.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.msg.vo.UserInfoBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class)
public interface UserFacadeService {

    @GetMapping("/facade/user/info")
    ResponseEntity<UserInfoBean> getUserInfo(@RequestParam("userId") Long userId);
}
