package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.facade.NewsFeignService;
import com.bxm.localnews.msg.param.VideoBlackParam;
import com.bxm.localnews.msg.param.VideoShareParam;
import com.bxm.localnews.msg.param.VideoViewParam;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewsFallbackFactory implements FallbackFactory<NewsFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsFallbackFactory.class);

    @Override
    public NewsFeignService create(Throwable throwable) {
        return new NewsFeignService() {
            @Override
            public void videoBlackConsume(VideoBlackParam videoBlackParam) {
                //记录请求参数
                LOGGER.error("videoBlackConsume,参数:{}", videoBlackParam);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void videoShareConsume(VideoShareParam videoShareParam) {
                //记录请求参数
                LOGGER.error("videoShareConsume,参数:{}", videoShareParam);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void videoViewConsume(VideoViewParam videoViewParam) {
                //记录请求参数
                LOGGER.error("videoViewConsume,参数:{}", videoViewParam);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void videoCommentConsume(Long userId, Long newsId) {
                //记录请求参数
                LOGGER.error("videoCommentConsume,参数:userId:{},newsId:{}", userId, newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }
        };
    }
}
